using UnityEngine;
using UnityEngine.UI;
using System.Collections;

public class VisualTipCanvas: MonoBehaviour {
	public float minSize = 64;
	public float maxSize = 128;
	public float speed = 1;
	public bool  alwaysShow = true;
	public RectTransform rtTip;
	public Image imgTip;

	private float elapsedTime = 0;
	private Vector2 pos;
	
	void  Awake (){
		rtTip.anchoredPosition = Vector2.zero;
		rtTip.sizeDelta = Vector2.zero;
		imgTip.enabled = false;
	}
	
	void  Update (){
		float r;
		if (alwaysShow) {
			if (Input.GetMouseButtonDown(0)) {
				elapsedTime = 0;		
				pos.x = Input.mousePosition.x-Screen.width/2.0f;
				pos.y = (Input.mousePosition.y-Screen.height/2.0f);
				
				r = minSize;
				DrawTip(r);
				imgTip.color = new Color(imgTip.color.r, imgTip.color.g,imgTip.color.b,1.0f);
				imgTip.enabled = true;
			}
			else if (imgTip.enabled) {
				elapsedTime += (Time.deltaTime*speed);
				if (elapsedTime<1) {
					r  = Mathf.Lerp(minSize, maxSize, elapsedTime);
					DrawTip(r);
					imgTip.color = new Color(imgTip.color.r, imgTip.color.g,imgTip.color.b,1.0f- elapsedTime);
				}
				else
					imgTip.enabled = false;
			}
		}
		else {
			// Draw only if enabled
			if (imgTip.enabled) {
				elapsedTime += (Time.deltaTime*speed);
				if (elapsedTime<1) {
					r  = Mathf.Lerp(minSize, maxSize, elapsedTime);
					DrawTip(r);
					imgTip.color = new Color(imgTip.color.r, imgTip.color.g,imgTip.color.b,1.0f- elapsedTime);
				}
				else
					imgTip.enabled = false;
			}
		}
	}


	void  DrawTip ( float size  ){
		rtTip.anchoredPosition = pos;
		rtTip.sizeDelta = Vector2.one * size;
	}
	
	// EXTERNAL CALL
	public void  ShowTipAt ( Vector3 p  ){
		pos.x = p.x-Camera.main.pixelWidth/2.0f;;
		pos.y = p.y-Camera.main.pixelHeight/2.0f;;
		imgTip.enabled = true;
		elapsedTime = 0;
		DrawTip(minSize);
	}

}